function lon=oct_readlon(ncid)
% OCT_READLON Read longitude using procedural netcdf API
try
  lon = netcdf.getVar(ncid,netcdf.inqVarID(ncid,'lon_rho'));
catch
  try
    lon = 1e-5 * netcdf.getVar(ncid,netcdf.inqVarID(ncid,'x_rho'));
  catch
    error('OCT_READLON: no horizontal coordinate found')
  end
end
return
