function lat=oct_readlat(ncid)
% OCT_READLAT Read latitude using procedural netcdf API
try
  lat = netcdf.getVar(ncid,netcdf.inqVarID(ncid,'lat_rho'));
catch
  try
    lat = 1e-5 * netcdf.getVar(ncid,netcdf.inqVarID(ncid,'y_rho'));
  catch
    error('OCT_READLAT: no horizontal coordinate found')
  end
end
return
