function [lat,lon,mask,var]=oct_get_var(hisfile,gridfile,vname,tindex,...
                                    vlevel,coef,rempts)
% OCT_GET_VAR Procedural wrapper for get_var reading using octave-netcdf
disp(['--',vname,'--'])
if isempty(gridfile), gridfile=hisfile; end

if strcmp(vname,'h') || strcmp(vname,'pm') || strcmp(vname,'pn')
  [lat,lon,mask]=oct_read_latlonmask(gridfile,'r');
  ncid = netcdf.open(gridfile,'NC_NOWRITE');
  vid = netcdf.inqVarID(ncid,vname);
  var = netcdf.getVar(ncid,vid);
  netcdf.close(ncid);
  mask(mask==0)=NaN;
  var = mask .* var;
elseif vname(1)=='*'
  % delegate to existing derived-variable routines (they operate on files)
  switch vname
    case '*Ke'
      [lat,lon,mask,var]=get_ke(hisfile,gridfile,tindex,vlevel,coef);
    case '*Pot_vort'
      [lat,lon,mask,var]=get_pv(hisfile,gridfile,tindex,vlevel,coef);
    case '*Rho'
      [lat,lon,mask,var]=get_rho(hisfile,gridfile,tindex,vlevel,coef);
    otherwise
      error('oct_get_var: unhandled derived variable')
  end
else
  [type,vlev]=get_type(hisfile,vname,vlevel);
  [lat,lon,mask]=oct_read_latlonmask(gridfile,type);
  var = coef .* mask .* oct_get_hslice(hisfile,gridfile,vname,tindex,vlev,type);
end

% Remove boundary values
lat=rempoints(lat,rempts);
lon=rempoints(lon,rempts);
mask=rempoints(mask,rempts);
var=rempoints(var,rempts);
return
