function var=oct_get_hslice(fname,gname,vname,tindex,level,type);
% OCT_GET_HSLICE Procedural replacement for get_hslice using octave-netcdf
ncid = netcdf.open(fname,'NC_NOWRITE');
if level==0
  % 2D variable
  try
    v = netcdf.getVar(ncid,netcdf.inqVarID(ncid,vname));
    if ndims(v)==3
      var = squeeze(v(tindex,:,:));
    else
      var = squeeze(v);
    end
  catch
    var = [];
  end

  % Correction for wetting/drying
  ngid = netcdf.open(gname,'NC_NOWRITE');
  try
    h = netcdf.getVar(ngid,netcdf.inqVarID(ngid,'h'));
  catch
    h = [];
  end
  netcdf.close(ngid);

  try
    hm = netcdf.getVar(ncid,netcdf.inqVarID(ncid,'hmorph'));
    if ndims(hm)==3, hm = squeeze(hm(tindex,:,:)); end
  catch
    hm = [];
  end
  if ~isempty(hm), h = hm; end
  try
    zeta = netcdf.getVar(ncid,netcdf.inqVarID(ncid,'zeta'));
    if ndims(zeta)==3, zeta = squeeze(zeta(tindex,:,:)); end
  catch
    zeta = [];
  end
  if isempty(zeta), zeta = 0 .* h; end
  D = zeta + h;
  try
    Dcrit = netcdf.getVar(ncid,netcdf.inqVarID(ncid,'Dcrit')) + 1.e-5;
  catch
    Dcrit = 0.2 + 1.e-5;
  end
  if isempty(Dcrit), Dcrit = 0.2 + 1.e-5; end
  if type=='u'
    D = rho2u_2d(D);
  elseif type=='v'
    D = rho2v_2d(D);
  end
  var(D<=Dcrit) = NaN;
elseif level>0
  % sigma level of a 3D variable
  try
    v = netcdf.getVar(ncid,netcdf.inqVarID(ncid,vname));
    if ndims(v)==4
      var = squeeze(v(tindex,level,:,:));
    elseif ndims(v)==3
      var = squeeze(v(level,:,:));
    else
      var = squeeze(v);
    end
  catch
    var = [];
  end
  var(var==0)=NaN;
else
  % horizontal level of a 3D variable (interpolate)
  z = oct_get_depths(fname,gname,tindex,type);
  try
    v = netcdf.getVar(ncid,netcdf.inqVarID(ncid,vname));
    if ndims(v)==4
      var_sigma = squeeze(v(tindex,:,:,:));
    elseif ndims(v)==3
      var_sigma = squeeze(v(:,:,:));
    else
      var_sigma = v;
    end
  catch
    var_sigma = [];
  end
  var = vinterp(var_sigma,z,level);
end
netcdf.close(ncid);
return
function var=oct_get_hslice(fname,gname,vname,tindex,level,type)
% OCT_GET_HSLICE Procedural variant of get_hslice using octave-netcdf
ncid = netcdf.open(fname,'NC_NOWRITE');
% read variable depending on level
if level==0
  vid = netcdf.inqVarID(ncid,vname);
  data = netcdf.getVar(ncid,vid);
  % data dims: time x ... ; extract time slice
  try
    var = squeeze(data(tindex,:,:));
  catch
    var = squeeze(data(:,:,tindex));
  end
  % correction for wetting/drying
  ngid = netcdf.open(gname,'NC_NOWRITE');
  try
    h = netcdf.getVar(ngid,netcdf.inqVarID(ngid,'h'));
  catch
    h = [];
  end
  netcdf.close(ngid)
  try
    hmorph = squeeze(netcdf.getVar(ncid,netcdf.inqVarID(ncid,'hmorph')));
  catch
    hmorph = [];
  end
  if ~isempty(hmorph), h=hmorph; end
  try
    zeta = squeeze(netcdf.getVar(ncid,netcdf.inqVarID(ncid,'zeta'),(tindex-1),1));
  catch
    try
      zeta = squeeze(netcdf.getVar(ncid,netcdf.inqVarID(ncid,'zeta')));
      zeta = squeeze(zeta(tindex,:,:));
    catch
      zeta = 0.*h;
    end
  end
  D = zeta + h;
  try
    Dcrit = netcdf.getVar(ncid,netcdf.inqVarID(ncid,'Dcrit')) + 1.e-5;
  catch
    Dcrit = 0.2 + 1.e-5;
  end
  if type=='u'
    D = rho2u_2d(D);
  elseif type=='v'
    D = rho2v_2d(D);
  end
  var(D<=Dcrit)=NaN;
elseif level>0
  vid = netcdf.inqVarID(ncid,vname);
  data = netcdf.getVar(ncid,vid);
  % assume dims: time x s_rho x eta x xi
  try
    var = squeeze(data(tindex,level,:,:));
  catch
    var = squeeze(data(level,tindex,:,:));
  end
  var(var==0)=NaN;
else
  % interpolate at z = level
  z = oct_get_depths(fname,gname,tindex,type);
  vid = netcdf.inqVarID(ncid,vname);
  data = netcdf.getVar(ncid,vid);
  % attempt to get [time s eta xi]
  try
    var_sigma = squeeze(data(tindex,:,:,:));
  catch
    var_sigma = squeeze(data(:,:,:,tindex));
  end
  var = vinterp(var_sigma,z,level);
end
netcdf.close(ncid);
return
