function [day,month,year,imonth,thedate]=oct_get_date(fname,tindex,Yorig)
% OCT_GET_DATE Procedural variant of get_date using octave-netcdf
if isempty(Yorig), Yorig=nan; end
ncid = netcdf.open(fname,'NC_NOWRITE');
time = [];
try
  vid = netcdf.inqVarID(ncid,'scrum_time');
  time = netcdf.getVar(ncid,vid);
catch
end
if isempty(time)
  try
    vid = netcdf.inqVarID(ncid,'ocean_time');
    time = netcdf.getVar(ncid,vid);
  catch
  end
end
netcdf.close(ncid);
if isempty(time)
  year=0; imonth=0; day=0; month=''; thedate=''; return
end
% time may be vector; select element
if numel(time)>=tindex
  time_val = double(time(tindex));
else
  time_val = double(time(1));
end

Month=[ 'Jan';'Feb';'Mar';'Apr';'May';'Jun';'Jul';'Aug';'Sep';'Oct';'Nov';'Dec'];
if isnan(Yorig)
  year=floor(1+time_val/(24*3600*360));
  if time_val<=0, time_val=time_val-(year-1)*24*3600*360; end
  imonth=floor(1+rem(time_val/(24*3600*30),12));
  day=floor(1+rem(time_val/(24*3600),30));
else
  [year,imonth,day,h,mi,s]=datevec(time_val/(24*3600)+datenum(Yorig,1,1));
end
month=Month(imonth,:);
if isnan(Yorig)
 thedate=[num2str(day),' ',month,' ',num2str(year)];
else
 thedate=[num2str(day),' ',month,' ',num2str(year),' ',num2str(h),'H'];
end
return
