function var=get_hslice(fname,gname,vname,tindex,level,type);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% function var=get_hslice(fname,vname,tindex,level,type);
%
% get an horizontal slice of a CROCO variable
%
% input:
%
%  fname    CROCO netcdf file name (average or history) (string)
%  gname    CROCO netcdf grid file name  (string)
%  vname    name of the variable (string)
%  tindex   time index (integer)
%  level    vertical level of the slice (scalar):
%             level =   integer >= 1 and <= N
%                       take a slice along a s level (N=top))
%             level =   0
%                       2D horizontal variable (like zeta)
%             level =   real < 0
%                       interpole a horizontal slice at z=level
%  type    type of the variable (character):
%             r for 'rho' for zeta, temp, salt, w(!)
%             w for 'w'   for AKt
%             u for 'u'   for u, ubar
%             v for 'v'   for v, vbar
%
% output:
%
%  var     horizontal slice (2D matrix)
%
%
%
%  Further Information:  
%  http://www.croco-ocean.org
%  
%  This file is part of CROCOTOOLS
%
%  CROCOTOOLS is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published
%  by the Free Software Foundation; either version 2 of the License,
%  or (at your option) any later version.
%
%  CROCOTOOLS is distributed in the hope that it will be useful, but
%  WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software
%  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
%  MA  02111-1307  USA
%
%  Copyright (c) 2002-2006 by Pierrick Penven 
%  e-mail:Pierrick.Penven@ird.fr  
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ncid = netcdf.open(fname,'NC_NOWRITE');
if level==0
%
% 2D variable
%
   try
     tmp = netcdf.getVar(ncid,netcdf.inqVarID(ncid,vname));
     var = squeeze(tmp(tindex,:,:));
   catch
     netcdf.close(ncid);
     error(['Variable ',vname,' not found in ',fname])
   end
%
% Correction for wetting/drying
%
   ngid = netcdf.open(gname,'NC_NOWRITE');
   try
     h = netcdf.getVar(ngid,netcdf.inqVarID(ngid,'h'));
   catch
     netcdf.close(ngid);
     netcdf.close(ncid);
     error(['h not found in ',gname])
   end
   netcdf.close(ngid)
   try
     hmorph = squeeze(netcdf.getVar(ncid,netcdf.inqVarID(ncid,'hmorph')));
   catch
     hmorph = [];
   end
   if ~isempty(hmorph), h=hmorph; end;
   try
     zeta = squeeze(netcdf.getVar(ncid,netcdf.inqVarID(ncid,'zeta')));
   catch
     zeta = zeros(size(h));
   end
   D = zeta(tindex,:,:)+h;
   try
     Dcrit = netcdf.getVar(ncid,netcdf.inqVarID(ncid,'Dcrit')) + 1.e-5;
   catch
     Dcrit = 0.2+1.e-5;
   end
   if type=='u',
   if type=='u'
     D=rho2u_2d(D);
   elseif type=='v'
     D=rho2v_2d(D);
   end
   var(D<=Dcrit)=NaN;
elseif level>0
%
% Get a sigma level of a 3D variable
%
  try
    tmp = netcdf.getVar(ncid,netcdf.inqVarID(ncid,vname));
    var = squeeze(tmp(tindex,level,:,:));
  catch
    netcdf.close(ncid);
    error(['Variable ',vname,' not found in ',fname])
  end
  var(var==0)=NaN;
else
%
% Get a horizontal level of a 3D variable
%
% Get the depths of the sigma levels
%
  z=get_depths(fname,gname,tindex,type);
%
% Read the 3d matrix and do the interpolation
%
  try
    tmp = netcdf.getVar(ncid,netcdf.inqVarID(ncid,vname));
    var_sigma = squeeze(tmp(tindex,:,:,:));
  catch
    netcdf.close(ncid);
    error(['Variable ',vname,' not found in ',fname])
  end
  var = vinterp(var_sigma,z,level);
end
netcdf.close(ncid);
return
return
