function oct_plot_tide(grdname,frcname,k,cff,skp,coastfileplot)
% oct_plot_tide: procedural netcdf replacement for plot_tide
rad=pi/180.0;

% Read grid
ng = netcdf.open(grdname,'NC_NOWRITE');
rlon = netcdf.getVar(ng, netcdf.inqVarID(ng,'lon_rho'));
rlat = netcdf.getVar(ng, netcdf.inqVarID(ng,'lat_rho'));
rmask = netcdf.getVar(ng, netcdf.inqVarID(ng,'mask_rho'));
rangle = netcdf.getVar(ng, netcdf.inqVarID(ng,'angle'));
netcdf.close(ng)
[M,L]=size(rlat);

% Read forcing
nf = netcdf.open(frcname,'NC_NOWRITE');
Eamp = netcdf.getVar(nf, netcdf.inqVarID(nf,'tide_Eamp'), k-1, [1 1]);
% The above getVar call may vary; instead read full and index
try
  tide_Eamp = squeeze(netcdf.getVar(nf, netcdf.inqVarID(nf,'tide_Eamp'), [k-1 0 0], [1 M L]));
  tide_Cmax = squeeze(netcdf.getVar(nf, netcdf.inqVarID(nf,'tide_Cmax'), [k-1 0 0], [1 ceil(M/skp) ceil(L/skp)]));
  tide_Cmin = squeeze(netcdf.getVar(nf, netcdf.inqVarID(nf,'tide_Cmin'), [k-1 0 0], [1 ceil(M/skp) ceil(L/skp)]));
  tide_Cangle = rad * squeeze(netcdf.getVar(nf, netcdf.inqVarID(nf,'tide_Cangle'), [k-1 0 0], [1 ceil(M/skp) ceil(L/skp)]));
  cmpt = netcdf.getVar(nf, netcdf.inqVarID(nf,'components'));
catch
  % fallback: read full variables and slice
  tide_Eamp = squeeze(netcdf.getVar(nf, netcdf.inqVarID(nf,'tide_Eamp')));
  tide_Eamp = tide_Eamp(k,:,:);
  tide_Cmax = squeeze(netcdf.getVar(nf, netcdf.inqVarID(nf,'tide_Cmax')));
  tide_Cmax = squeeze(tide_Cmax(k,1:skp:M,1:skp:L));
  tide_Cmin = squeeze(netcdf.getVar(nf, netcdf.inqVarID(nf,'tide_Cmin')));
  tide_Cmin = squeeze(tide_Cmin(k,1:skp:M,1:skp:L));
  tide_Cangle = rad * squeeze(netcdf.getVar(nf, netcdf.inqVarID(nf,'tide_Cangle')));
  tide_Cangle = squeeze(tide_Cangle(k,1:skp:M,1:skp:L));
  cmpt = netcdf.getVar(nf, netcdf.inqVarID(nf,'components'));
end
netcdf.close(nf)

disp(['Plot tidal component : ',cmpt(3*k-2:3*k)])

slon = rlon(1:skp:M,1:skp:L);
slat = rlat(1:skp:M,1:skp:L);
smask = rmask(1:skp:M,1:skp:L);
rmask(rmask==0)=NaN;

disp(['Max currents: ',num2str(max(max(tide_Cmax)),2),' m/s'])

domaxis=[min(min(rlon)) max(max(rlon)) min(min(rlat)) max(max(rlat))];

m_proj('mercator','lon',[domaxis(1) domaxis(2)],'lat',[domaxis(3) domaxis(4)]);
m_pcolor(rlon,rlat,rmask.*tide_Eamp)
shading flat
hold on
m_ellipse(cff*smask.*tide_Cmax,cff*smask.*tide_Cmin,smask.*tide_Cangle,slon,slat,'k');
if ~isempty(coastfileplot)
  m_usercoast(coastfileplot,'patch',[.9 .9 .9]);
end
hold off
title(['Amplitude [m] of tide : ',cmpt(3*k-2:3*k)])
m_grid('box','fancy','xtick',5,'ytick',5,'tickdir','out','fontsize',7);
end
