function oct_nc_add_tides(fname,Ntides,start_tide_mjd,components)
% oct_nc_add_tides: create/add tidal variables using octave-netcdf procedural API
% Same behavior as nc_add_tides but uses netcdf.* (octave-netcdf)

ncid = netcdf.open(fname, 'NC_WRITE');
% get format: assume file already exists and is writable
% define dimension
try
  dimid = netcdf.defDim(ncid, 'tide_period', Ntides);
catch
  % If already defined, ignore
end

% define vars (use define mode)
netcdf.reDef(ncid);

varid = netcdf.defVar(ncid, 'tide_period', 'NC_DOUBLE', dimid);
netcdf.putAtt(ncid,varid,'long_name','Tide angular period');
netcdf.putAtt(ncid,varid,'units','Hours');

% define 3D variables: tide_Ephase, tide_Eamp, tide_Cmin, tide_Cmax, tide_Cangle, tide_Cphase, tide_Pamp, tide_Pphase
eta_rho_id = netcdf.inqDimID(ncid,'eta_rho');
xi_rho_id  = netcdf.inqDimID(ncid,'xi_rho');
dimids = [netcdf.inqDim(ncid,dimid)];
% For procedural API we need dim IDs array
try
  tide_dims = [netcdf.inqDimID(ncid,'tide_period'), eta_rho_id, xi_rho_id];
catch
  tide_dims = [];
end

if ~isempty(tide_dims)
  netcdf.defVar(ncid,'tide_Ephase','NC_DOUBLE',tide_dims);
  netcdf.defVar(ncid,'tide_Eamp','NC_DOUBLE',tide_dims);
  netcdf.defVar(ncid,'tide_Cmin','NC_DOUBLE',tide_dims);
  netcdf.defVar(ncid,'tide_Cmax','NC_DOUBLE',tide_dims);
  netcdf.defVar(ncid,'tide_Cangle','NC_DOUBLE',tide_dims);
  netcdf.defVar(ncid,'tide_Cphase','NC_DOUBLE',tide_dims);
  netcdf.defVar(ncid,'tide_Pamp','NC_DOUBLE',tide_dims);
  netcdf.defVar(ncid,'tide_Pphase','NC_DOUBLE',tide_dims);
end

% global attributes
netcdf.putAtt(ncid, netcdf.getConstant('NC_GLOBAL'), 'date', date);
netcdf.putAtt(ncid, netcdf.getConstant('NC_GLOBAL'), 'start_tide_mjd', start_tide_mjd);
netcdf.putAtt(ncid, netcdf.getConstant('NC_GLOBAL'), 'components', components);

netcdf.endDef(ncid);
netcdf.close(ncid);
end
