function data=oct_ext_data_tpxo(datafile,dataname,itide,lon,lat,type,Roa)
% oct_ext_data_tpxo: procedural replacement for ext_data_tpxo

default=NaN;
missval=NaN;
dl=1;
[x,y,data]=oct_read_data_tpxo(datafile,dataname,itide,lon,lat,type,dl);

if dataname(1)=='u' | dataname(1)=='v'
  [xh,yh,h]=oct_read_data_tpxo(datafile,'h',[],lon,lat,'r',2*dl);
  h=interp2(xh,yh,h,x,y,'linear');
  h(h<10)=NaN;
  data=data./h;
end

data=get_missing_val(x,y,data,missval,Roa,default);
data=interp2(x,y,data,lon,lat,'cubic');
end
