function [amp,pha]=oct_ext_data_sal(grdname,salname,ampname,phaname,itide)
% oct_ext_data_sal: procedural replacement for ext_data_sal

default=NaN;
% Read grid
ng = netcdf.open(grdname,'NC_NOWRITE');
lonid = netcdf.inqVarID(ng,'lon_rho');
latid = netcdf.inqVarID(ng,'lat_rho');
lon = netcdf.getVar(ng,lonid);
lat = netcdf.getVar(ng,latid);
netcdf.close(ng);
[M,L]=size(lon);

dl=2;
lonmin=min(min(lon))-dl;
lonmax=max(max(lon))+dl;
latmin=min(min(lat))-dl;
latmax=max(max(lat))+dl;

nc = netcdf.open(salname,'NC_NOWRITE');
X = netcdf.getVar(nc, netcdf.inqVarID(nc,'lon'));
Y = netcdf.getVar(nc, netcdf.inqVarID(nc,'lat'));

j=find(Y>=latmin & Y<=latmax);
i1=find(X-360>=lonmin & X-360<=lonmax);
i2=find(X>=lonmin & X<=lonmax);
i3=find(X+360>=lonmin & X+360<=lonmax);
x=cat(1,X(i1)-360,X(i2),X(i3)+360);
y=Y(j);

% Amplitude
if ~isempty(i2)
  amp = squeeze(netcdf.getVar(nc, netcdf.inqVarID(nc,ampname), itide-1, j(1)-1, i2(1)-1));
else
  amp = [];
end
if ~isempty(i1)
  a1 = squeeze(netcdf.getVar(nc, netcdf.inqVarID(nc,ampname), itide-1, j(1)-1, i1(1)-1));
  amp = cat(2,a1,amp);
end
if ~isempty(i3)
  a3 = squeeze(netcdf.getVar(nc, netcdf.inqVarID(nc,ampname), itide-1, j(1)-1, i3(1)-1));
  amp = cat(2,amp,a3);
end

% Phase
if ~isempty(i2)
  pha = squeeze(netcdf.getVar(nc, netcdf.inqVarID(nc,phaname), itide-1, j(1)-1, i2(1)-1));
else
  pha = [];
end
if ~isempty(i1)
  p1 = squeeze(netcdf.getVar(nc, netcdf.inqVarID(nc,phaname), itide-1, j(1)-1, i1(1)-1));
  pha = cat(2,p1,pha);
end
if ~isempty(i3)
  p3 = squeeze(netcdf.getVar(nc, netcdf.inqVarID(nc,phaname), itide-1, j(1)-1, i3(1)-1));
  pha = cat(2,pha,p3);
end

netcdf.close(nc);

cdata=amp.*exp(1i*pha*pi/180);
i_cdata(:,:)=interp2(x,y,cdata,lon,lat,'linear');
amp=abs(i_cdata);
pha=180/pi*angle(i_cdata);
end
