function  oct_create_runoff(runoffname,grdname,title,...
    qbart,qbarc,rivername,rivernumber,...
    runoffname_StrLen,dir,psource_ncfile_ts,...
    biol,pisces,quota, Yorig)
% OCT_CREATE_RUNOFF Create an empty netcdf runoff file using octave-netcdf
disp([' Creating the file : ',runoffname])

timeref = 1 ;
if nargin < 14
  timeref = 0 ;
end
if timeref == 1
  time_unit_att = ['days since ',sprintf('%04d', Yorig),'-01-01 00:00:00'];
  calendar_att = 'proleptic_gregorian' ;
else
  time_unit_att = ['days'];
  calendar_att = 'climatological year' ;
end

% Create file (clobber existing)
ncid = netcdf.create(runoffname,'CLOBBER');

% Define dimensions
dim_qbar_time = netcdf.defDim(ncid,'qbar_time',length(qbart));
dim_n_qbar = netcdf.defDim(ncid,'n_qbar',rivernumber);
dim_runoffname_StrLen = netcdf.defDim(ncid,'runoffname_StrLen',runoffname_StrLen);
dim_one = netcdf.defDim(ncid,'one',1);
dim_two = netcdf.defDim(ncid,'two',2);

NC_DOUBLE = netcdf.getConstant('NC_DOUBLE');
NC_CHAR   = netcdf.getConstant('NC_CHAR');

% Define variables
var_qbar_time = netcdf.defVar(ncid,'qbar_time',NC_DOUBLE,dim_qbar_time);
netcdf.putAtt(ncid,var_qbar_time,'long_name','runoff time');
netcdf.putAtt(ncid,var_qbar_time,'units',time_unit_att);
netcdf.putAtt(ncid,var_qbar_time,'calendar',calendar_att);
netcdf.putAtt(ncid,var_qbar_time,'cycle_length',qbarc);

if psource_ncfile_ts
    var_temp_src_time = netcdf.defVar(ncid,'temp_src_time',NC_DOUBLE,dim_qbar_time);
    netcdf.putAtt(ncid,var_temp_src_time,'long_name','runoff time');
    netcdf.putAtt(ncid,var_temp_src_time,'units',time_unit_att);
    netcdf.putAtt(ncid,var_temp_src_time,'calendar',calendar_att);
    netcdf.putAtt(ncid,var_temp_src_time,'cycle_length',qbarc);

    var_salt_src_time = netcdf.defVar(ncid,'salt_src_time',NC_DOUBLE,dim_qbar_time);
    netcdf.putAtt(ncid,var_salt_src_time,'long_name','runoff time');
    netcdf.putAtt(ncid,var_salt_src_time,'units',time_unit_att);
    netcdf.putAtt(ncid,var_salt_src_time,'calendar',calendar_att);
    netcdf.putAtt(ncid,var_salt_src_time,'cycle_length',qbarc);
end

var_runoff_name = netcdf.defVar(ncid,'runoff_name',NC_CHAR,[dim_runoffname_StrLen dim_n_qbar]);
netcdf.putAtt(ncid,var_runoff_name,'long_name','runoff name');

var_Qbar = netcdf.defVar(ncid,'Qbar',NC_DOUBLE,[dim_n_qbar dim_qbar_time]);
netcdf.putAtt(ncid,var_Qbar,'long_name','runoff discharge');
netcdf.putAtt(ncid,var_Qbar,'units','m3.s-1');

if psource_ncfile_ts
    var_temp_src = netcdf.defVar(ncid,'temp_src',NC_DOUBLE,[dim_n_qbar dim_qbar_time]);
    netcdf.putAtt(ncid,var_temp_src,'long_name','runoff temp conc.');
    netcdf.putAtt(ncid,var_temp_src,'units','deg.celsius');

    var_salt_src = netcdf.defVar(ncid,'salt_src',NC_DOUBLE,[dim_n_qbar dim_qbar_time]);
    netcdf.putAtt(ncid,var_salt_src,'long_name','runoff salt conc.');
    netcdf.putAtt(ncid,var_salt_src,'units','psu');

    if biol
        var_no3_src_time = netcdf.defVar(ncid,'no3_src_time',NC_DOUBLE,dim_qbar_time);
        netcdf.putAtt(ncid,var_no3_src_time,'long_name','runoff time');
        netcdf.putAtt(ncid,var_no3_src_time,'units',time_unit_att);
        netcdf.putAtt(ncid,var_no3_src_time,'calendar',calendar_att);
        netcdf.putAtt(ncid,var_no3_src_time,'cycle_length',360);

        var_NO3_src = netcdf.defVar(ncid,'NO3_src',NC_DOUBLE,[dim_n_qbar dim_qbar_time]);
        netcdf.putAtt(ncid,var_NO3_src,'long_name','runoff no3 conc.');
        netcdf.putAtt(ncid,var_NO3_src,'units','mmol.m-3');
        if pisces
           var_po4_src_time = netcdf.defVar(ncid,'po4_src_time',NC_DOUBLE,dim_qbar_time);
           netcdf.putAtt(ncid,var_po4_src_time,'long_name','runoff time');
           netcdf.putAtt(ncid,var_po4_src_time,'units',time_unit_att);
           netcdf.putAtt(ncid,var_po4_src_time,'calendar',calendar_att);
           netcdf.putAtt(ncid,var_po4_src_time,'cycle_length',360);

           var_PO4_src = netcdf.defVar(ncid,'PO4_src',NC_DOUBLE,[dim_n_qbar dim_qbar_time]);
           netcdf.putAtt(ncid,var_PO4_src,'long_name','runoff po4 conc.');
           netcdf.putAtt(ncid,var_PO4_src,'units','mmol.m-3');

           var_si_src_time = netcdf.defVar(ncid,'si_src_time',NC_DOUBLE,dim_qbar_time);
           netcdf.putAtt(ncid,var_si_src_time,'long_name','runoff time');
           netcdf.putAtt(ncid,var_si_src_time,'units',time_unit_att);
           netcdf.putAtt(ncid,var_si_src_time,'calendar',calendar_att);
           netcdf.putAtt(ncid,var_si_src_time,'cycle_length',360);

           var_Si_src = netcdf.defVar(ncid,'Si_src',NC_DOUBLE,[dim_n_qbar dim_qbar_time]);
           netcdf.putAtt(ncid,var_Si_src,'long_name','runoff si conc.');
           netcdf.putAtt(ncid,var_Si_src,'units','mmol.m-3');

           var_dic_src_time = netcdf.defVar(ncid,'dic_src_time',NC_DOUBLE,dim_qbar_time);
           netcdf.putAtt(ncid,var_dic_src_time,'long_name','runoff time');
           netcdf.putAtt(ncid,var_dic_src_time,'units',time_unit_att);
           netcdf.putAtt(ncid,var_dic_src_time,'calendar',calendar_att);
           netcdf.putAtt(ncid,var_dic_src_time,'cycle_length',360);

           var_DIC_src = netcdf.defVar(ncid,'DIC_src',NC_DOUBLE,[dim_n_qbar dim_qbar_time]);
           netcdf.putAtt(ncid,var_DIC_src,'long_name','runoff dic conc.');
           netcdf.putAtt(ncid,var_DIC_src,'units','mmol.m-3');

           var_doc_src_time = netcdf.defVar(ncid,'doc_src_time',NC_DOUBLE,dim_qbar_time);
           netcdf.putAtt(ncid,var_doc_src_time,'long_name','runoff time');
           netcdf.putAtt(ncid,var_doc_src_time,'units',time_unit_att);
           netcdf.putAtt(ncid,var_doc_src_time,'calendar',calendar_att);
           netcdf.putAtt(ncid,var_doc_src_time,'cycle_length',360);

           var_DOC_src = netcdf.defVar(ncid,'DOC_src',NC_DOUBLE,[dim_n_qbar dim_qbar_time]);
           netcdf.putAtt(ncid,var_DOC_src,'long_name','runoff doc conc.');
           netcdf.putAtt(ncid,var_DOC_src,'units','mmol.m-3');

           var_talk_src_time = netcdf.defVar(ncid,'talk_src_time',NC_DOUBLE,dim_qbar_time);
           netcdf.putAtt(ncid,var_talk_src_time,'long_name','runoff time');
           netcdf.putAtt(ncid,var_talk_src_time,'units',time_unit_att);
           netcdf.putAtt(ncid,var_talk_src_time,'calendar',calendar_att);
           netcdf.putAtt(ncid,var_talk_src_time,'cycle_length',360);

           var_TALK_src = netcdf.defVar(ncid,'TALK_src',NC_DOUBLE,[dim_n_qbar dim_qbar_time]);
           netcdf.putAtt(ncid,var_TALK_src,'long_name','runoff talk conc.');
           netcdf.putAtt(ncid,var_TALK_src,'units','mmol.m-3');
           if quota
              var_don_src_time = netcdf.defVar(ncid,'don_src_time',NC_DOUBLE,dim_qbar_time);
              netcdf.putAtt(ncid,var_don_src_time,'long_name','runoff time');
              netcdf.putAtt(ncid,var_don_src_time,'units',time_unit_att);
              netcdf.putAtt(ncid,var_don_src_time,'calendar',calendar_att);
              netcdf.putAtt(ncid,var_don_src_time,'cycle_length',360);

              var_DON_src = netcdf.defVar(ncid,'DON_src',NC_DOUBLE,[dim_n_qbar dim_qbar_time]);
              netcdf.putAtt(ncid,var_DON_src,'long_name','runoff don conc.');
              netcdf.putAtt(ncid,var_DON_src,'units','mmol.m-3');
            
              var_dop_src_time = netcdf.defVar(ncid,'dop_src_time',NC_DOUBLE,dim_qbar_time);
              netcdf.putAtt(ncid,var_dop_src_time,'long_name','runoff time');
              netcdf.putAtt(ncid,var_dop_src_time,'units',time_unit_att);
              netcdf.putAtt(ncid,var_dop_src_time,'calendar',calendar_att);
              netcdf.putAtt(ncid,var_dop_src_time,'cycle_length',360);

              var_DOP_src = netcdf.defVar(ncid,'DOP_src',NC_DOUBLE,[dim_n_qbar dim_qbar_time]);
              netcdf.putAtt(ncid,var_DOP_src,'long_name','runoff dop conc.');
              netcdf.putAtt(ncid,var_DOP_src,'units','mmol.m-3');
           end
        end
    end
end

% End define mode
netcdf.endDef(ncid);

% Global attributes
NC_GLOBAL = netcdf.getConstant('NC_GLOBAL');
netcdf.putAtt(ncid,NC_GLOBAL,'title',title);
netcdf.putAtt(ncid,NC_GLOBAL,'date',date);
netcdf.putAtt(ncid,NC_GLOBAL,'grd_file',grdname);
netcdf.putAtt(ncid,NC_GLOBAL,'type','CROCO runoff file');

% Write time variables
netcdf.putVar(ncid,var_qbar_time,double(qbart));
if psource_ncfile_ts
    netcdf.putVar(ncid,var_temp_src_time,double(qbart));
    netcdf.putVar(ncid,var_salt_src_time,double(qbart));
    if biol
         netcdf.putVar(ncid,var_no3_src_time,double(qbart));
         if pisces
            netcdf.putVar(ncid,var_po4_src_time,double(qbart));
            netcdf.putVar(ncid,var_si_src_time,double(qbart));
            netcdf.putVar(ncid,var_dic_src_time,double(qbart));
            netcdf.putVar(ncid,var_doc_src_time,double(qbart));
            netcdf.putVar(ncid,var_talk_src_time,double(qbart));
            if quota
               netcdf.putVar(ncid,var_don_src_time,double(qbart));
               netcdf.putVar(ncid,var_dop_src_time,double(qbart));
            end
         end
    end
end

% Write river names (char array). netcdf.putVar expects start/count in zero-based indices
for k=1:rivernumber
    netcdf.putVar(ncid,var_runoff_name,[0 k-1],[runoffname_StrLen 1],uint8(rivername(k,:)));
end

% Close file
netcdf.close(ncid);
return
