function oct_write_time_attributes(ncid,time_name,cycle,...
                                time_unit_att,...
                                time_second_unit_att, ...
                                calendar_att, ...
                                insecond,...
                                add_cycle) ;
% Write time-related attributes using octave-netcdf
try
  varid = netcdf.inqVarID(ncid,time_name);
catch
  error(['Variable ',time_name,' not found in file.']);
end

% calendar
netcdf.putAtt(ncid,varid,'calendar',calendar_att);

if exist('insecond','var') && insecond == 1
  netcdf.putAtt(ncid,varid,'units',time_second_unit_att);
else
  netcdf.putAtt(ncid,varid,'units',time_unit_att);
end

if exist('add_cycle','var') && add_cycle == 1
  netcdf.putAtt(ncid,varid,'cycle_length',cycle);
end
return
