%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Build a CROCO initial file from Levitus Data (octave-netcdf versions)
%
clear all
close all
%%%%%%%%%%%%%%%%%%%%% USERS DEFINED VARIABLES %%%%%%%%%%%%%%%%%%%%%%%%
%
%  Title 
%
title='Climatology';
%
% Common parameters
%
crocotools_param

%  Data climatologies file names:
%
temp_month_data  = [climato_dir,'temp_month.cdf'];
temp_ann_data    = [climato_dir,'temp_ann.cdf'];
insitu2pot       = 1;   %1: transform in-situ temperature to potential temperature
salt_month_data  = [climato_dir,'salt_month.cdf'];
salt_ann_data    = [climato_dir,'salt_ann.cdf'];
%
%%%%%%%%%%%%%%%%%%% END USERS DEFINED VARIABLES %%%%%%%%%%%%%%%%%%%%%%%
%
% Title
%
disp(' ')
disp([' Making initial file: ',ininame])
disp(' ')
disp([' Title: ',title])
%
% Initial file
%
if  ~exist('vtransform')
    vtransform=1; %Old Vtransform
    disp([' NO VTRANSFORM parameter found'])
    disp([' USE TRANSFORM default value vtransform = 1'])
end
oct_create_inifile(ininame,grdname,title,...
               theta_s,theta_b,hc,N,...
               tini,'clobber',vtransform);
%
% Horizontal and vertical interp/extrapolations 
%
disp(' ')
disp(' Interpolations / extrapolations')
disp(' ')
disp(' Temperature...')
oct_ext_tracers_ini(ininame,grdname,temp_month_data,temp_ann_data,...
            'temperature','temp','r',tini);
disp(' ')
disp(' Salinity...')
oct_ext_tracers_ini(ininame,grdname,salt_month_data,salt_ann_data,...
             'salinity','salt','r',tini);
%
% Geostrophy
%
if (insitu2pot)
  disp(' ')
  disp(' Compute potential temperature from in-situ...')
  oct_getpot(ininame,grdname)
end
if (makeplot == 1)
    disp(' ')
    disp(' Make a few plots...')
    test_clim(ininame,grdname,'temp',1,coastfileplot)
    figure
    test_clim(ininame,grdname,'salt',1,coastfileplot)
end
%
% End
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
