function oct_make_coast(grid_file,coast_file)
% OCT_MAKE_COAST read lon/lat from grid using octave-netcdf and call m_map
if nargin<1
  grid_file='croco_grd.nc';
end
if nargin<2
  res='i';
  prename='coastline';
else
  lc=length(coast_file);
  res=coast_file(lc-4);
  prename=coast_file(1:lc-6);
end

ncid = netcdf.open(grid_file,'NC_NOWRITE');
lon = netcdf.getVar(ncid,netcdf.inqVarID(ncid,'lon_rho'));
lat = netcdf.getVar(ncid,netcdf.inqVarID(ncid,'lat_rho'));
netcdf.close(ncid);

lonmin=min(min(lon));
lonmax=max(max(lon));
latmin=min(min(lat));
latmax=max(max(lat));
dl=.1*max(lonmax-lonmin,latmax-latmin);
lonmin=lonmin-dl;
lonmax=lonmax+dl;
latmin=latmin-dl;
latmax=latmax+dl;

m_proj('mercator','lon',[lonmin lonmax],'lat',[latmin latmax]);

fname=[prename,'_',res,'.mat'];
disp(['Processing ',fname,' ...'])

switch res
  case 'c'
    m_gshhs_c('save',fname);
  case 'l'
    m_gshhs_l('save',fname);
  case 'i'
    m_gshhs_i('save',fname);
  case 'h'
    m_gshhs_h('save',fname);
  case 'f'
    m_gshhs_f('save',fname);
end

m_usercoast(fname,'patch',[.9 .9 .9]);
m_grid('box','fancy','tickdir','in');

% Save cstline data in lon,lat form to be used in editmask
load(fname)
lonc=ncst(:,1);
latc=ncst(:,2);
fname2=[prename,'_',res,'_mask.mat'];
eval(['save ',fname2,' lonc latc']);
return
