function  [pm,pn,dndx,dmde]=oct_get_metrics(grdname)
% OCT_GET_METRICS  Compute metrics using octave-netcdf
ncid = netcdf.open(grdname,'NC_NOWRITE');

latu = netcdf.getVar(ncid,netcdf.inqVarID(ncid,'lat_u'));
lonu = netcdf.getVar(ncid,netcdf.inqVarID(ncid,'lon_u'));
latv = netcdf.getVar(ncid,netcdf.inqVarID(ncid,'lat_v'));
lonv = netcdf.getVar(ncid,netcdf.inqVarID(ncid,'lon_v'));

netcdf.close(ncid);
[Mp,L]=size(latu);
[M,Lp]=size(latv);
Lm=L-1;
Mm=M-1;

% pm and pn

dx=zeros(Mp,Lp);
dy=zeros(Mp,Lp);
dx(:,2:L)=spheric_dist(latu(:,1:Lm),latu(:,2:L),...
                       lonu(:,1:Lm),lonu(:,2:L));
dx(:,1)=dx(:,2);
dx(:,Lp)=dx(:,L);

dy(2:M,:)=spheric_dist(latv(1:Mm,:),latv(2:M,:),...
                       lonv(1:Mm,:),lonv(2:M,:));
dy(1,:)=dy(2,:);
dy(Mp,:)=dy(M,:);

pm=1./dx;
pn=1./dy;    
% dndx and dmde

dndx(2:M,2:L)=0.5*(1./pn(2:M,3:Lp) - 1./pn(2:M,1:Lm));
dmde(2:M,2:L)=0.5*(1./pm(3:Mp,2:L) - 1./pm(1:Mm,2:L));
dndx(1,:)=0;
dndx(Mp,:)=0;
dndx(:,1)=0;
dndx(:,Lp)=0;
dmde(1,:)=0;
dmde(Mp,:)=0;
dmde(:,1)=0;
dmde(:,Lp)=0;
return
