function  create_nestedndepo(ndeponame,parentname,grdname,title,ndepot,ndepoc)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 	Create an empty netcdf ndepo forcing file (for PISCES)
%       ndeponame: name of the ndepo file
%       grdname: name of the grid file
%       title: title in the netcdf file  
%
%  Further Information:  
%  http://www.croco-ocean.org
%  
%  This file is part of CROCOTOOLS
%
%  CROCOTOOLS is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published
%  by the Free Software Foundation; either version 2 of the License,
%  or (at your option) any later version.
%
%  CROCOTOOLS is distributed in the hope that it will be useful, but
%  WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software
%  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
%  MA  02111-1307  USA
%
%  Copyright (c) 2004-2006 by Pierrick Penven 
%  e-mail:Pierrick.Penven@ird.fr  
%  Update : Gildas Cambon 13 Oct 2009
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
nc=netcdf(grdname);
L=length(nc('xi_psi'));
M=length(nc('eta_psi'));
close(nc);
Lp=L+1;
Mp=M+1;
nw = netcdf(ndeponame, 'write');
%redef(nw);
%
%  Create dimensions
%
nw('xi_u') = L;
nw('eta_u') = Mp;
nw('xi_v') = Lp;
nw('eta_v') = M;
nw('xi_rho') = Lp;
nw('eta_rho') = Mp;
nw('xi_psi') = L;
nw('eta_psi') = M;
nw('ndepo_time') = length(ndepot);
%
%  Create variables and attributes
%
nw{'ndepo_time'} = ncdouble('ndepo_time');
nw{'ndepo_time'}.long_name = ncchar('ndepo time');
nw{'ndepo_time'}.long_name = 'ndepo time';
nw{'ndepo_time'}.units = ncchar('days');
nw{'ndepo_time'}.units = 'days';
nw{'ndepo_time'}.cycle_length = ndepoc;
nw{'ndepo_time'}.field = ncchar('time, scalar, series');
nw{'ndepo_time'}.field = 'time, scalar, series';

%
nw{'ndepo'} = ncdouble('ndepo_time', 'eta_rho', 'xi_rho');
nw{'ndepo'}.long_name = ncchar('Nitrogen Deposition');
nw{'ndepo'}.long_name = 'Nitrogen Deposition';
nw{'ndepo'}.units = ncchar('KgN m-2 s-1');
nw{'ndepo'}.units = 'KgN m-2 s-1';
nw{'ndepo'}.field = ncchar('ndepo, scalar, series');
nw{'ndepo'}.field = 'ndepo, scalar, series';
%
nw{'noyndepo'} = ncdouble('ndepo_time', 'eta_rho', 'xi_rho');
nw{'noyndepo'}.long_name = ncchar('NOy Deposition');
nw{'noyndepo'}.long_name = 'NOy Deposition';
nw{'noyndepo'}.units = ncchar('KgN m-2 s-1');
nw{'noyndepo'}.units = 'KgN m-2 s-1';
nw{'noyndepo'}.field = ncchar('noyndepo, scalar, series');
nw{'noyndepo'}.field = 'noyndepo, scalar, series';
%
nw{'nhxndepo'} = ncdouble('ndepo_time', 'eta_rho', 'xi_rho');
nw{'nhxndepo'}.long_name = ncchar('NHx Deposition');
nw{'nhxndepo'}.long_name = 'NHx Deposition';
nw{'nhxndepo'}.units = ncchar('KgN m-2 s-1');
nw{'nhxndepo'}.units = 'KgN m-2 s-1';
nw{'nhxndepo'}.field = ncchar('nhxndepo, scalar, series');
nw{'nhxndepo'}.field = 'nhxndepo, scalar, series';
%
%endef(nw);

%
% Create global attributes
%

nw.title = ncchar(title);
nw.title = title;
nw.date = ncchar(date);
nw.date = date;
nw.grd_file = ncchar(grdname);
nw.grd_file = grdname;
nw.parent_file = ncchar(parentname);
nw.parent_file = parentname;

%
% Write time variables
%

nw{'ndepo_time'}(:) = ndepot;


close(nw);
return
