function  create_nesteddust(dustname,parentname,grdname,title,dustt,dustc)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 	Create an empty netcdf dust forcing file (for PISCES)
%       dustname: name of the dust file
%       grdname: name of the grid file
%       title: title in the netcdf file  
%
%  Further Information:  
%  http://www.croco-ocean.org
%  
%  This file is part of CROCOTOOLS
%
%  CROCOTOOLS is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published
%  by the Free Software Foundation; either version 2 of the License,
%  or (at your option) any later version.
%
%  CROCOTOOLS is distributed in the hope that it will be useful, but
%  WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software
%  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
%  MA  02111-1307  USA
%
%  Copyright (c) 2004-2006 by Pierrick Penven 
%  e-mail:Pierrick.Penven@ird.fr  
%  Update : Gildas Cambon 13 Oct 2009
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% options for write_time_attributes
insecond =  0 ;
add_cycle = 1 ; 
%
% Initialize Yorig if not provided
if ~exist('Yorig', 'var') ,  Yorig = []; , end
%
% Get time attributes
[time_unit_att,time_second_unit_att,calendar_att]=...
    get_time_attributes(Yorig);
%
nc=netcdf(grdname);
L=length(nc('xi_psi'));
M=length(nc('eta_psi'));
close(nc);
Lp=L+1;
Mp=M+1;
nw = netcdf(dustname, 'clobber');
%redef(nw);
%
%  Create dimensions
%
nw('xi_u') = L;
nw('eta_u') = Mp;
nw('xi_v') = Lp;
nw('eta_v') = M;
nw('xi_rho') = Lp;
nw('eta_rho') = Mp;
nw('xi_psi') = L;
nw('eta_psi') = M;
nw('dust_time') = length(dustt);
%
%  Create variables and attributes
%
nw{'dust_time'} = ncdouble('dust_time');
nw{'dust_time'}.long_name = ncchar('dust time');
nw{'dust_time'}.long_name = 'dust time';
nw{'dust_time'}.field = ncchar('time, scalar, series');
nw{'dust_time'}.field = 'time, scalar, series';
write_time_attributes(nc,'dust_time',dustc,time_unit_att,time_second_unit_att,...
  calendar_att,insecond,add_cycle);

nw{'dust'} = ncdouble('dust_time', 'eta_rho', 'xi_rho');
nw{'dust'}.long_name = ncchar('Fe Dust Deposition');
nw{'dust'}.long_name = 'Fe Dust Deposition';
nw{'dust'}.units = ncchar('nmol Fe m-3');
nw{'dust'}.units = 'nmol Fe m-3';
nw{'dust'}.field = ncchar('Fe Dust Deposition, scalar, series');
nw{'dust'}.field = 'Fe Dust Deposition, scalar, series';

nw{'dustfer'} = ncdouble('dust_time', 'eta_rho', 'xi_rho');
nw{'dustfer'}.long_name = ncchar('Fe Dust Deposition');
nw{'dustfer'}.long_name = 'Fe Dust Deposition';
nw{'dustfer'}.units = ncchar('Kg m-2 s-1');
nw{'dustfer'}.units = 'Kg m-2 s-1';
nw{'dustfer'}.field = ncchar('dustfer, scalar, series');
nw{'dustfer'}.field = 'dustfer, scalar, series';
%
nw{'dustpo4'} = ncdouble('dust_time', 'eta_rho', 'xi_rho');
nw{'dustpo4'}.long_name = ncchar('PO4 Dust Deposition');
nw{'dustpo4'}.long_name = 'PO4 Dust Deposition';
nw{'dustpo4'}.units = ncchar('Kg m-2 s-1');
nw{'dustpo4'}.units = 'Kg m-2 s-1';
nw{'dustpo4'}.field = ncchar('dustpo4, scalar, series');
nw{'dustpo4'}.field = 'dustpo4, scalar, series';
%
nw{'dustsi'} = ncdouble('dust_time', 'eta_rho', 'xi_rho');
nw{'dustsi'}.long_name = ncchar('Si Dust Deposition');
nw{'dustsi'}.long_name = 'Si Dust Deposition';
nw{'dustsi'}.units = ncchar('Kg m-2 s-1');
nw{'dustsi'}.units = 'Kg m-2 s-1';
nw{'dustsi'}.field = ncchar('dustsi, scalar, series');
nw{'dustsi'}.field = 'dustsi, scalar, series';
%
nw{'solubility2'} = ncdouble('dust_time', 'eta_rho', 'xi_rho');
nw{'solubility2'}.long_name = ncchar('Fe solubility from Mahowald');
nw{'solubility2'}.long_name = 'Fe solubility from Mahowald';
nw{'solubility2'}.units = ncchar('%');
nw{'solubility2'}.units = '%';
nw{'solubility2'}.field = ncchar('solubility2, scalar, series');
nw{'solubility2'}.field = 'solubility2, scalar, series';

endef(nw);

%
% Create global attributes
%

nw.title = ncchar(title);
nw.title = title;
nw.date = ncchar(date);
nw.date = date;
nw.grd_file = ncchar(grdname);
nw.grd_file = grdname;
nw.parent_file = ncchar(parentname);
nw.parent_file = parentname;

%
% Write time variables
%

nw{'dust_time'}(:) = dustt;


close(nw);
return
